/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import satisfyu.beachparty.registry.ObjectRegistry;

public class SandCastleBlock
extends Block {
    private static final VoxelShape BASE_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0));
    public static final BooleanProperty TALL_TOWER;
    public static final VoxelShape TALL_TOWER_SHAPE;
    public static final BooleanProperty RIGHT_TOWER;
    public static final VoxelShape RIGHT_TOWER_SHAPE;
    public static final BooleanProperty TOP_TOWER;
    public static final VoxelShape TOP_TOWER_SHAPE;
    public static final BooleanProperty LEFT_TOWER;
    public static final VoxelShape LEFT_TOWER_SHAPE;

    public SandCastleBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TALL_TOWER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_TOWER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP_TOWER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_TOWER, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[0]);
        if (((Boolean)state.m_61143_((Property)TALL_TOWER)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)TALL_TOWER_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)RIGHT_TOWER)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)RIGHT_TOWER_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)LEFT_TOWER)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)LEFT_TOWER_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)TOP_TOWER)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)TOP_TOWER_SHAPE);
        }
        return shape;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack handStack = player.m_21120_(hand);
        if (handStack.m_41720_() == ObjectRegistry.SAND_BUCKET.get() && !this.hasAllTowers(state)) {
            BooleanProperty tower = this.getTowerHitPos(hit);
            if (!((Boolean)state.m_61143_((Property)tower)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)tower, (Comparable)Boolean.valueOf(true)));
                this.exchangeStack(handStack, player, new ItemStack((ItemLike)ObjectRegistry.EMPTY_SAND_BUCKET.get()));
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        } else if (handStack.m_41720_() == ObjectRegistry.EMPTY_SAND_BUCKET.get()) {
            BooleanProperty tower;
            if (this.hasNoTowers(state)) {
                world.m_46961_(pos, false);
                this.exchangeStack(handStack, player, new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET.get()));
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (!this.hasNoTowers(state) && ((Boolean)state.m_61143_((Property)(tower = this.getTowerHitPos(hit)))).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)tower, (Comparable)Boolean.valueOf(false)));
                this.exchangeStack(handStack, player, new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET.get()));
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        world.m_7731_(pos, ((Block)ObjectRegistry.SAND_PILE.get()).m_49966_(), 3);
    }

    private void exchangeStack(ItemStack handStack, Player player, ItemStack possibleReturnStack) {
        ItemStack returnStack;
        ItemStack itemStack = returnStack = !player.m_150110_().f_35937_ ? possibleReturnStack : handStack;
        if (player.m_7500_()) {
            if (!player.m_150109_().m_36063_(returnStack)) {
                player.m_150109_().m_36054_(returnStack);
            }
            return;
        }
        Inventory inventory = player.m_150109_();
        int slot = inventory.m_36030_(handStack);
        handStack.m_41774_(1);
        if (player.m_150109_().m_8020_(slot).m_41619_()) {
            if (!inventory.m_36040_(slot, returnStack)) {
                player.m_36176_(returnStack, false);
            }
        } else if (!inventory.m_36054_(returnStack)) {
            player.m_36176_(returnStack, false);
        }
    }

    private BooleanProperty getTowerHitPos(BlockHitResult hitResult) {
        double x = hitResult.m_82450_().m_7096_();
        double z = hitResult.m_82450_().m_7094_();
        double relX = x - (double)hitResult.m_82425_().m_123341_();
        double relZ = z - (double)hitResult.m_82425_().m_123343_();
        if (relX >= 0.5 && relZ >= 0.5) {
            return TALL_TOWER;
        }
        if (relX < 0.5 && relZ >= 0.5) {
            return RIGHT_TOWER;
        }
        if (relX >= 0.5 && relZ < 0.5) {
            return LEFT_TOWER;
        }
        return TOP_TOWER;
    }

    private boolean hasAllTowers(BlockState state) {
        return (Boolean)state.m_61143_((Property)TALL_TOWER) != false && (Boolean)state.m_61143_((Property)RIGHT_TOWER) != false && (Boolean)state.m_61143_((Property)TOP_TOWER) != false && (Boolean)state.m_61143_((Property)LEFT_TOWER) != false;
    }

    private boolean hasNoTowers(BlockState state) {
        return (Boolean)state.m_61143_((Property)TALL_TOWER) == false && (Boolean)state.m_61143_((Property)RIGHT_TOWER) == false && (Boolean)state.m_61143_((Property)TOP_TOWER) == false && (Boolean)state.m_61143_((Property)LEFT_TOWER) == false;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        return world.m_8055_(blockPos).m_60783_((BlockGetter)world, blockPos, Direction.UP);
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET.get());
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TALL_TOWER, RIGHT_TOWER, TOP_TOWER, LEFT_TOWER});
    }

    static {
        TALL_TOWER_SHAPE = Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)15.0, (double)15.0);
        RIGHT_TOWER_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)11.0, (double)5.0, (double)12.0, (double)15.0);
        TOP_TOWER_SHAPE = Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
        LEFT_TOWER_SHAPE = Block.m_49796_((double)11.0, (double)1.0, (double)1.0, (double)15.0, (double)12.0, (double)5.0);
        TALL_TOWER = BooleanProperty.m_61465_((String)"tall");
        RIGHT_TOWER = BooleanProperty.m_61465_((String)"right");
        TOP_TOWER = BooleanProperty.m_61465_((String)"top");
        LEFT_TOWER = BooleanProperty.m_61465_((String)"left");
    }
}

